
//////////////////////////
//Created by Hammerhand//
////////////////////////
using System;
using System.Collections;
using Server.Items;
using Server.ContextMenus;
using Server.Misc;
using Server.Network;

namespace Server.Mobiles
{
	[CorpseName("A Soulless corpse")]
	public class Soulless : BaseCreature
	{
		public override bool ClickTitle{ get{ return false; } }
		private bool m_TrueForm;

		[Constructable]
		public Soulless()
			: base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			Title = "The Kindred";
			Hue = Utility.RandomSkinHue();

			{
				Body = 0x190;
				Name = "Soulless";
			}

			SetStr(650, 755);
			SetDex(130, 165);
			SetInt(161, 195);

			SetDamage(35, 43);

			SetHits(2500, 3500);

			SetResistance(ResistanceType.Physical, 65, 80);
			SetResistance(ResistanceType.Fire, 50, 60);
			SetResistance(ResistanceType.Cold, 30, 50);
			SetResistance(ResistanceType.Poison, 40, 50);
			SetResistance(ResistanceType.Energy, 50, 60);

			SetSkill(SkillName.Fencing, 130.8, 150.5);
			SetSkill(SkillName.Macing, 140.9, 160.0);
			SetSkill(SkillName.MagicResist, 150.0, 202.5);
			SetSkill(SkillName.Swords, 149.0, 168.5);
			SetSkill(SkillName.Tactics, 130.9, 180.0);
			SetSkill(SkillName.Wrestling, 150.0, 195.5);

			Fame = 10000;
			Karma = -10000;
			VirtualArmor = 50;
			
			int rndhue = Utility.RandomNeutralHue();

			Item chest = new WoodlandChest();
			chest.Hue = rndhue;
			chest.Movable = false;
			AddItem(chest);
			Item arms = new WoodlandArms();
			arms.Movable = false;
			arms.Hue = rndhue;
			AddItem(arms);
			Item legs = new WoodlandLegs();
			legs.Movable = false;
			legs.Hue = rndhue;
			AddItem(legs);
			Item helm = new PlateHelm();
			helm.Movable = false;
			helm.ItemID = 11123;
			helm.Hue = rndhue;
			AddItem(helm);
			Item gloves = new WoodlandGloves();
			gloves.Movable = false;
			gloves.Hue = rndhue;
			AddItem(gloves);
			Item gorget = new WoodlandGorget();
			gorget.Movable = false;
			gorget.Hue = rndhue;
			AddItem(gorget);
			Item belt = new WoodlandBelt();
			belt.Movable = false;
			belt.Hue = rndhue;
			AddItem(belt);
			AddItem( new Boots() );
			AddItem( new Cloak() );
			Item longsword = new ASoullessBlade();
			longsword.Movable = false;
			AddItem(longsword);
			
			if( Utility.RandomDouble() < 0.30 )
				PackItem(new ASoullessBlade());
		}
		public override void GenerateLoot()
		{
			AddLoot(LootPack.UltraRich, 2);
		}
		
		public override bool AlwaysMurderer { get { return true; } }
		public override Poison PoisonImmune{ get{ return m_TrueForm ? Poison.Lethal : null;; } }		
		public override Poison HitPoison{ get{ return m_TrueForm ? Poison.Deadly : null; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		
		public void Morph()
		{
			if ( m_TrueForm )
				return;

			m_TrueForm = true;

			Name = "Mega Soulless";
			BodyValue = 40;
			Hue = 2949;
			BaseSoundID = 357;

			Hits = HitsMax;
			Stam = StamMax;
			Mana = ManaMax;

			Say( "Tremble before my TRUE form!" );
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public override int HitsMax{ get{ return m_TrueForm ? 22000 : 22000; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public override int ManaMax{ get{ return 6000; } }
		
		public override void OnDamage( int amount, Mobile from, bool willKill, int typ )
		{
			base.OnDamage( amount, from, willKill, typ );
         
         // eats pet or summons
			if ( m_TrueForm && from is BaseCreature )
			{
				BaseCreature creature = (BaseCreature) from;
				
				if ( creature.Controlled || creature.Summoned )
				{
					creature.Kill();				
					
					Effects.PlaySound( Location, Map, 0x574 );
				}
			}
			
// 			if( Utility.RandomDouble() < 0.10 )
// 			   Server.Commands.ColorSpray.ColorSprayInit( 6, 20, this, from, true );
		}
		
		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );

			if ( 0.05 >= Utility.RandomDouble() )
				Ability.CriticalHit( defender );
		}
		
		public Soulless( Serial serial ) : base( serial )
		{
		}

		public override bool OnBeforeDeath()
		{
			if ( m_TrueForm )
			{
				return base.OnBeforeDeath();
			}
			else
			{
				Morph();
				return false;
			}
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );

			writer.Write( m_TrueForm );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 0:
					{
						m_TrueForm = reader.ReadBool();

						break;
					}
			}

		}
	}
}
